---
title: Omni IoT Server MQTT Client 開發手冊
tags: [Omni]

---

---
title: Omni IoT Server MQTT Client 開發手冊
tags: [MQTT, Client, 開發指南]

---

<Style>
code.redrose {
  color: #FFFFFF !important ; background-color:#E81E25 !important ; font-size: 14pt ;
}
code.get {
  color: #FFFFFF !important ; background-color:#62afff !important; font-size: 14pt;
}
   
code.post {
  color: #FFFFFF !important ; background-color:#48cc90 !important ; font-size: 14pt;
}

code.put {
  color: #FFFFFF !important ; background-color:#fca12f !important ; font-size: 14pt;
}
    
code.del {
  color: #FFFFFF !important ; background-color:#f83e3f !important; font-size: 14pt;
}
    
code.gettxt {
  color: #000000 !important  ; background-color:#d9edf6 !important ; font-size: 16pt;
}

code.posttxt {
  color: #000000 !important  ; background-color:#def0d8 !important; font-size: 16pt;
}
    
code.puttxt {
  color: #000000 !important  ; background-color:#fbf9e4 !important; font-size: 16pt;
}
    
code.deltxt {
  color: #000000 !important  ; background-color:#f2dedf !important; font-size: 16pt;
}

code.topic {
  color: #FFFFFF !important ; background-color:#6f42c1 !important ; font-size: 12pt;
}
</Style>


:::danger
**文件等級**: <code class="redrose">**內部機密**</code>
應簽署相關保密協議，不得轉載或散佈本檔案文件或其所含之任何訊息。
:::

| 日期       | 版號    | 說明  |人員|
| --------- | :--- | --------|---|
|2026/01/03||**【建立】** MQTT Client 開發手冊建立|Sam.W|

:::info
[TOC]
:::

---

# 🌐 系統簡介

![omni_server](https://hackmd.io/_uploads/HkgGgfBN-e.jpg)

OmniConnect IoT Server 提供 MQTT 與 RESTful API 雙通道架構。第三方應用系統（MQTT Client）可透過 MQTT 協議與 Omni Server 進行即時資料交換，包括讀取組態、監控即時狀態以及發送控制指令。

---

# 1. MQTT 連線與主題設置

## 🔌 連線相關設置

| 參數 | 預設值 | 說明 |
| :--- | :--- | :--- |
| **Broker Host** | `localhost` | MQTT Broker 位址 |
| **Broker Port** | `1883` | MQTT 非加密連線埠 (TLS 預設為 8883) |
| **Client ID** | `CID_xxxxx` | 第三方自定義唯一識別碼 (需全系統唯一) |
| **Keep Alive** | `60` | 建議維持 60 秒以保持連線穩定 |

> [!NOTE]
> 建議連線時設置 **Last Will and Testament (LWT)**，主題格式可參考本文件第 3 節。

## 📥 訂閱主題 (Subscribe)

連線完成後，Client 端**必須**訂閱以下主題以接收回應與通知：

| 主題格式 | 說明 | 備註 |
| :--- | :--- | :--- |
| <code class="topic">client/{OmniID}</code> | 接收來自特定 Omni 的廣播訊息 | 狀態異動主動通知 (Event) |
| <code class="topic">client/{CID}</code> | 接收 Omni 對此 Client 的專屬回應 | 指令請求的回應 (Response) |


## 循序流程


```sequence
Note left of Client: MQTT 連線設置

Note left of Client: 初始化
Client->MQTT Broker: 1.訂閱兩主題: client/<OmniID>，client/<CID>

Client->MQTT Broker: 2.取得組態資訊
MQTT Broker->Omni: 
Omni->MQTT Broker: 
MQTT Broker->Client: 

Client->MQTT Broker: 3.取得當前狀態
MQTT Broker->Omni: 
Omni->MQTT Broker: 
MQTT Broker->Client: 

Note left of Client: 正常通訊時

Note right of Client: 1.當有控制需求
Client->MQTT Broker: 控制
MQTT Broker->Omni:

Note right of Client: 2.當Omni狀態有更新時
Omni-->MQTT Broker: 狀態異動主動通知
MQTT Broker-->Client: 

```

---

# 2. MQTT 通訊規範

## Key 值說明
|Key值|說明|範例|
|---|---|---|
| **cmd** | 功能指令 (支援字串/整數) | `system.get_config`, `device.control`, `1` |
| **OmniID** | Omni Server 內部識別碼 | `OMNI-001` 或 `Omni_ABC123` |
| **cid** | 第三方客戶端 ID | `APP_01` |
| **timestamp**| Unix Timestamp (ms) | `1618822524863` |

## 動作指令對照表 (Command Mapping)

| 指令 (String Cmd) |  說明 |
| :--- | :--- |
| `system.get_config` | 查詢組態 |
| `system.get_status` |  查詢狀態 |
| `device.control` |  控制指令 |
| `system.config_response` |  回應組態 |
| `system.status_response` |  回應狀態 |
| `device.control_response` |  回應控制 |
| `system.offline_event` | LWT 異常離線通知 |

---

# 3. 功能發佈說明與範例

## ◉ 查詢系統組態 (system.get_config)
用於獲取系統內所有已連接設備的定義、ID、名稱及單位。

| 方向 | MQTT 主題 |
| :--- | :--- |
| **發佈 (Publish)** | <code class="topic">omni</code> 或 <code class="topic">omni/{OmniID}</code> |

:::spoiler Request (Send cmd: system.get_config)
```json
{
    "cmd": "system.get_config",
    "cid": "CLIENT_001",
    "timestamp": 1698289800000
}
```
:::

:::spoiler Response (Recv cmd : system.config_response)
```json
{
  "system": "Omni_28B2BD4C1481",
  "timestamp": 1698289800500,
  "status": 0,
  "cmd": "system.config_response",
  "devices": [
    {
      "objName": "MODBUS",
      "id": "1",
      "name": "環境感測器",
      "ver": "7",
      "online": 1,
      "config": {
         "temp": { 
           "name": "溫度", 
           "type": 0,
           "unit": "°C",
           "tag": [
             { "/": 10 },
             { ".": 1 }
           ]
         },
         "humi": { 
           "name": "濕度", 
           "type": 0,
           "unit": "%",
           "tag": [
             { "/": 10 },
             { ".": 1 }
           ]
         }
      }
    }
  ]
}
```

**欄位說明**:
- `system`: Omni Server 系統識別碼
- `timestamp`: Unix 時間戳（毫秒）
- `status`: 狀態碼（0=成功）
- `cmd`: 回應命令代碼（101）
- `devices[]`: 設備陣列
  - `objName`: 設備類型（MODBUS, MQTT, Module 等）
  - `id`: 設備 ID
  - `name`: 設備名稱
  - `ver`: 設備版本號
  - `online`: 在線狀態（1=在線, 0=離線）
  - `config{}`: 功能組態字典
    - `{funId}`: 功能 ID（如 "temp", "humi"）
      - `name`: 功能名稱
      - `type`: 功能類型（0=讀, 1=寫, 2=讀寫）
      - `unit`: 單位（可選）
      - `tag[]`: 標籤陣列（可選，用於數值轉換）
        - `/`: 除數（用於縮放）
        - `.`: 小數位數
      - `range[]`: 允許範圍（可選）
      - `setrange[]`: 可設定範圍（可選）
      - `bypass`: 強制更新設定（可選，布林值）
        - `false`: (預設) 僅在數值發生變化時才發送更新。
        - `true`: 無論數值是否變化，每次輪詢或數據處理時皆強制發送更新。適用於需要高頻率監控或確保連線活躍的場景。

:::

## ◉ 查詢系統狀態 (system.get_status)
獲取設備目前的即時數值與連線狀態。

| 方向 | MQTT 主題 |
| :--- | :--- |
| **發佈 (Publish)** | <code class="topic">omni/{OmniID}</code> |

:::spoiler Request (Send cmd: system.get_status)
```json
{
    "cmd": "system.get_status",
    "cid": "CLIENT_001",
    "timestamp": 1698289800000
}
```
:::

:::spoiler Response (Recv Cmd: system.status_response)
```json
{
  "system": "Omni_28B2BD4C1481",
  "timestamp": 1698289800600,
  "status": 0,
  "cmd": "system.status_response",
  "devices": [
    {
      "objName": "MODBUS",
      "id": "1",
      "online": 1,
      "status": [
        "MODBUS|1|temp|25.5|1698289800000",
        "MODBUS|1|humi|60.2|1698289800000"
      ]
    }
  ]
}
```

**Status 格式說明**:
```
{ObjName}|{ID}|{funID}|{value}|{timestamp}
```
- `ObjName`: 設備類型
- `ID`: 設備 ID
- `funID`: 功能 ID
- `value`: 當前數值
- `timestamp`: 該數值的時間戳（毫秒）

:::

## ◉ 發送控制指令 (device.control)
對具備控制能力的設備（如開關、燈光）下達操作指令。

| 方向 | MQTT 主題 |
| :--- | :--- |
| **發佈 (Publish)** | <code class="topic">omni/{OmniID}</code> |

:::spoiler Request (Send cmd: device.control)
```json
{
    "cmd": "device.control",
    "cid": "CLIENT_001",
    "timestamp": 1698289800000,
    "payload": {
        "actions": [
            "MODBUS|1|switch_1|1"
        ]
    }
}
```

**Actions 格式說明**:
```
{ObjName}|{ID}|{funID}|{value}
```
- `ObjName`: 設備類型
- `ID`: 設備 ID
- `funID`: 功能 ID
- `value`: 要設定的值

**範例**:
- `"MODBUS|1|switch_1|1"` - 將 MODBUS 設備 1 的 switch_1 設為 1（開）
- `"MODBUS|2|temp_set|25"` - 將 MODBUS 設備 2 的 temp_set 設為 25
:::

:::spoiler Response (Recv cmd = device.control_response)
```json
{
    "cmd": "device.control_response",
    "timestamp": 1698289800800,
    "status": 0
}
```
*`status: 0` 表示指令已成功轉發至終端設備。*

**狀態碼說明**:
- `0`: 成功
- `1`: 一般錯誤
- `2`: 參數錯誤
- `3`: 設備離線
:::

## ◉ 異常離線通知 (LWT)
當 Omni Server 因為網路問題或異常程序中止與 Broker 的連線時，Broker 會主動向 Client 發佈此訊息。

| 方向 | MQTT 主題 | 訊息內容 |
| :--- | :--- | :--- |
| **通知 (Notify)** | <code class="topic">from/omni/{OmniID}</code> | JSON 格式離線通知 |

:::spoiler LWT Message Format
```json
{
  "cmd": "system.offline_event",
  "system": "Omni_28B2BD4C1481",
  "timestamp": 1768189503431, // 請注意這裡時間戳為啟動時間
  "status": "offline"
}
```

**說明**: 當 Omni Server 異常斷線時，MQTT Broker 會自動發佈此訊息到 `from/omni/{OmniID}` 主題，通知所有訂閱者該 Server 已離線。
:::

---

# 注意事項

1. **主題權限條件**: 請確保 MQTT Broker 資料庫中已正確設定連線帳號對 `client/` 與 `omni/` 前綴主題的讀寫權限。
2. **QoS 等級**: 
   - 建議指令（cmd 3）使用 **QoS 1** 以確保指令到達。
   - 一般狀態查詢或廣播建議使用 **QoS 0** 或 **QoS 1**。
3. **資料壓縮**: 目前預設為純 JSON 字串，通訊量大時建議檢查網路頻寬。
4. **JSON 格式**: 
   - ✅ 所有欄位名稱使用 **camelCase** 格式（如 `objName`, `timestamp`）
   - ❌ 不要使用 PascalCase（如 `ObjName`, `TimeStamp`）
5. **時間戳格式**: 統一使用 Unix 時間戳（毫秒），UTC 時區
6. **Null 值處理**: 回應中不會包含值為 null 的欄位（如 `bypass`, `range`, `setrange`）

---
